<?php
namespace VM\FinancialStatementsBundle\Services\Restrictions\DataStructure;


use VM\ApiBundle\Entity\Company;
use VM\ApiBundle\Entity\CompanyAllegroCategoryItem;
use VM\ApiBundle\Entity\Department;
use VM\ApiBundle\Entity\MarketSegment;
use VM\ApiBundle\Entity\User;

class SegmentDS
{
    public $valid = true;

    public $segmentSymbol = '';

    public $restrictions = array();

    public $departments = array();

    public $equipment = array();

    public $departmentsErrors = array();

    public $surfaceErrors = array();

    public $itemsTypeErrors = array();

    public $restrictionsItemsTypes = array();

    public $errors = array();

    public $zapasyCount = 0;

    /**
     * @var MaxPackagesDS
     */
    public $maxPackages;

    public function __construct()
    {
        $this->maxPackages = new MaxPackagesDS();
    }

    /**
     * @param MarketSegment $MarketSegment
     * @param Company $Company
     */
    public function setData(MarketSegment $MarketSegment, Company $Company)
    {
        $this->segmentSymbol = $MarketSegment->getSymbol();
        $this->restrictions = json_decode($MarketSegment->getRestrictions(),true);
        $this->addEquipment($Company->getPlaces());
    }

    public function isInEquipment(ItemDS $ItemDS)
    {
        foreach($this->equipment as $equipmentDepartment)
        {
            /** @var ItemDS $equipmentItemDS */
            foreach($equipmentDepartment as $equipmentItemDS)
            {
                if($equipmentItemDS->id == $ItemDS->id && ($equipmentItemDS->used < $equipmentItemDS->quantity))
                {
                    $equipmentItemDS->used++;
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * @param ItemDS $ItemDS
     * @return bool|ItemDS
     */
    public function getItemFromEquipment(ItemDS $ItemDS)
    {
        foreach($this->equipment as $equipmentDepartment)
        {
            /** @var ItemDS $equipmentItemDS */
            foreach($equipmentDepartment as $equipmentItemDS)
            {
                if($equipmentItemDS->id == $ItemDS->id && ($equipmentItemDS->used < $equipmentItemDS->quantity))
                {
                    return $equipmentItemDS;
                }
            }
        }
        return null;
    }

    /**
     * @param $id
     * @return null|ItemDS
     */
    public function getItemFromEquipmentForItemId($id)
    {
        foreach($this->equipment as $equipmentDepartment)
        {
            /** @var ItemDS $equipmentItemDS */
            foreach($equipmentDepartment as $equipmentItemDS)
            {
                if($equipmentItemDS->id == $id)
                {
                    return $equipmentItemDS;
                }
            }
        }
        return null;
    }

    public function addDepartment(DepartmentDS $DepartmentDS)
    {
        $this->departments[] = $DepartmentDS;
        if(!is_null($DepartmentDS->restrictions['items']))
        {
            foreach($DepartmentDS->restrictions['items'] as $symbol => $requiredCount)
            {
                if($DepartmentDS->isRestrictedForProduction)
                {
                    if(!isset($this->restrictionsItemsTypes[$symbol]))
                    {
                        $this->restrictionsItemsTypes[$symbol] = 0;
                    }
                    $this->restrictionsItemsTypes[$symbol] += $requiredCount;
                }
            }
        }
    }

    public function addDepartmentError($departmentSymbol,$message)
    {
        if(!isset($this->departmentsErrors[$departmentSymbol]))
        {
            $this->departmentsErrors[$departmentSymbol] = array();
        }
        $this->departmentsErrors[$departmentSymbol][] = $message;
    }

    public function addItemsTypeError($symbol,$message)
    {
        if(!isset($this->itemsTypeErrors[$symbol]))
        {
            $this->itemsTypeErrors[$symbol] = array();
        }
        $this->itemsTypeErrors[$symbol][] = $message;
    }

    public function addSurfaceError($symbol,$message)
    {
        if(!isset($this->surfaceErrors[$symbol]))
        {
            $this->surfaceErrors[$symbol] = array();
        }
        $this->surfaceErrors[$symbol][] = $message;
    }

    public function getMaxProductionForDay()
    {
        $min = $this->maxPackages->getMaxEfficiency('prod');

        if($min > $this->maxPackages->productionAmountPerDay)
        {
            $min = $this->maxPackages->productionAmountPerDay;
        }
//        if($min > $this->maxPackages->surface && $this->maxPackages->surface >= 0)
//        {
//            $min = $this->maxPackages->surface;
//        }
        if($this->maxPackages->surface < 1)
        {
            $min = $min * $this->maxPackages->surface;
        }

        return $min;
    }

    public function updateMaxPackagesForDepartmentStatement($departmentSymbol, $newValue)
    {
        if(!isset($this->maxPackages->departments[$departmentSymbol]))
        {
            $this->maxPackages->departments[$departmentSymbol] = -1;
        }
        if($newValue >= 0 && ($this->maxPackages->departments[$departmentSymbol] < 0 || $this->maxPackages->departments[$departmentSymbol] > $newValue))
        {
            $this->maxPackages->departments[$departmentSymbol] = $newValue;
        }
    }

    public function updateMaxPackagesForDepartment($departmentSymbol, $newValue)
    {
        $maxPackages = $this->maxPackages->requiresForDepartments[$departmentSymbol]->maxPackages;
        if($newValue >= 0 && ($maxPackages < 0 || $maxPackages > $newValue))
        {
            $this->maxPackages->requiresForDepartments[$departmentSymbol]->maxPackages = $newValue;
        }
    }

    public function updateMaxPackagesSurface($newValue)
    {
        if($newValue >= 0 && ($this->maxPackages->surface < 0 || $this->maxPackages->surface > $newValue))
        {
            $this->maxPackages->surface = $newValue;
        }
    }

    public function updateMaxPackagesBiRForDepartment($departmentSymbol,$newValue)
    {
        $maxPackagesBiR = $this->maxPackages->requiresForDepartments[$departmentSymbol]->maxPackagesBiR;
        if($newValue >= 0 && ($maxPackagesBiR < 0 || $maxPackagesBiR > $newValue))
        {
            $this->maxPackages->requiresForDepartments[$departmentSymbol]->maxPackagesBiR = $newValue;
        }
    }

    public function updateMaxPackagesPiRForDepartment($departmentSymbol,$newValue)
    {
        $maxPackagesPiR = $this->maxPackages->requiresForDepartments[$departmentSymbol]->maxPackagesPiR;
        if($newValue >= 0 && ($maxPackagesPiR < 0 || $maxPackagesPiR > $newValue))
        {
            $this->maxPackages->requiresForDepartments[$departmentSymbol]->maxPackagesPiR = $newValue;
        }
    }

    public function getCountAllEmployees()
    {
        $allEmployees = 0;
        /** @var DepartmentDS $DepartmentDS */
        foreach($this->departments as $DepartmentDS)
        {
            $allEmployees += $DepartmentDS->Employees->countAll;
        }
        return $allEmployees;
    }

    private function addEquipment($Items)
    {
        /** @var CompanyAllegroCategoryItem $Item */
        foreach($Items as $Item)
        {
            if(!isset($this->equipment[$Item->getItem()->getType()->getSymbol()]))
            {
                $this->equipment[$Item->getItem()->getType()->getSymbol()] = array();
            }
            if(isset($this->equipment[$Item->getItem()->getType()->getSymbol()][$Item->getItem()->getId()]))
            {
                $this->equipment[$Item->getItem()->getType()->getSymbol()][$Item->getItem()->getId()]->quantity += $Item->getQuantity();
            }
            else
            {
                $this->equipment[$Item->getItem()->getType()->getSymbol()][$Item->getItem()->getId()] = new ItemDS($Item->getItem(),$Item->getQuantity());
            }
        }
    }
}

class MaxPackagesDS
{
    public $departments = array();
    public $surface = -1;
    public $restrictionsPersonnel = array();
    public $efficiency = array();
    public $productionAmountPerDay = -1;
    public $productionAmount = -1;
    public $LiczbaZmian = 1;
    /**
     * @var array of RequiresForDepartmentDS
     */
    public $requiresForDepartments = array();

    /**
     * @var RequiresForDepartmentDS
     */
    public $requiresAll;

    public function __construct()
    {
        $this->requiresAll = new RequiresForDepartmentDS();
    }

    public function getMaxPackages()
    {
        $max = -1;

        foreach($this->departments as $departmentMax)
        {
            if($max < 0 || $max > $departmentMax)
            {
                $max = $departmentMax;
            }
        }
        if($max < 0 || $max > $this->surface)
        {
            $max = $this->surface;
        }
        if($max < 0 || $max > $this->productionAmountPerDay)
        {
            $max = $this->productionAmountPerDay;
        }

        return $max;
    }

    public function getMaxEfficiency($type)
    {
        $maxEfficiency = -1;
        foreach($this->efficiency as $efficiencyForDepartment)
        {
            foreach($efficiencyForDepartment as $efficiencyType => $value)
            {
                if($efficiencyType == $type && ($maxEfficiency<0 || $maxEfficiency > $value))
                {
                    $maxEfficiency = $value;
                }
            }
        }
        return $maxEfficiency;
    }

    public function getSumEfficiency($type)
    {
        $sumEfficiency = 0;
        foreach($this->efficiency as $efficiencyForDepartment)
        {
            foreach($efficiencyForDepartment as $efficiencyType => $value)
            {
                if($efficiencyType == $type)
                {
                    $sumEfficiency += $value;
                }
            }
        }
        return $sumEfficiency;
    }

    public function setRequiresAll()
    {
        $this->requiresAll = new RequiresForDepartmentDS();
        /** @var RequiresForDepartmentDS $RequiresForDepartmentDS */
        foreach($this->requiresForDepartments as $RequiresForDepartmentDS)
        {
            $this->requiresAll->packages += $RequiresForDepartmentDS->packages;
            $this->requiresAll->employees += $RequiresForDepartmentDS->employees;
            $this->requiresAll->surfaceEquipment += $RequiresForDepartmentDS->surfaceEquipment;
            $this->requiresAll->surfaceEmployee += $RequiresForDepartmentDS->surfaceEmployee;
        }
    }
}

class RequiresForDepartmentDS
{
    public $packages = 0;
    public $employees = 0;
    public $surfaceEquipment = 0;
    public $surfaceEmployee = 0;
    //max dla BiR
    public $maxPackagesBiR = -1;
    //max dla PiR
    public $maxPackagesPiR = -1;
    public $maxPackages = -1;

    public function updateMaxPackagesBiR($newValue)
    {
        if($newValue >= 0 && ($this->maxPackagesBiR < 0 || $this->maxPackagesBiR > $newValue && $newValue >= 0))
        {
            $this->maxPackagesBiR = $newValue;
        }
    }

    public function updateMaxPackagesPiR($newValue)
    {
        if($newValue >= 0 && ($this->maxPackagesPiR < 0 || $this->maxPackagesPiR > $newValue && $newValue >= 0))
        {
            $this->maxPackagesPiR = $newValue;
        }
    }

    public function updateMaxPackages($newValue)
    {
        if($newValue >= 0 && ($this->maxPackages < 0 || $this->maxPackages > $newValue && $newValue >= 0))
        {
            $this->maxPackages = $newValue;
        }
    }
}